	function N = CA_ORDER_S(Wc, Ws, Amax, Amin)
	%
	% 	Computes required order for an analog lowpass Cauer filter
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1986-9-27
	% 	Modified by: 	LW, 1991-06-09, 2000-10-31, 2002-07-28, 2013-12-29
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	% 	Reference:		Daniels R.W.: Approximation Methods for Electronic Filter Design, 
	%					McGraw-Hill, 1974.'
	
	if (Wc >= Ws)
		error('Not a lowpass filter. Must have Wc < Ws')  
	elseif ( Amax <= 0 | Amax >= Amin)
		error('The passband attenuation must be 0 < Amax < Amin')
	elseif ( Amin <= 0)
		error('The stopband attenuation Amin must be > 0')
	elseif ( Amax > 12)
		error('The passband attenuation is too large')
	elseif ( Amin > 200)
		error('The stopband attenuation is too large')
	end 
	Apn = Amax*log(10)/20;
	epsilon2 = 2*exp(Apn)*sinh(Apn);
	L = sqrt((10^(0.1*Amin) - 1)/epsilon2);
	W = Ws/Wc;
	Kkl = COMPLETE_ELLIPTIC_INTEGRAL(1/L);
	Kkil = COMPLETE_ELLIPTIC_INTEGRAL(sqrt(1-1/(L*L)));
	Kk1 = COMPLETE_ELLIPTIC_INTEGRAL(sqrt(1-1/(W*W)));
	Kk = COMPLETE_ELLIPTIC_INTEGRAL(1/W);
	N = Kkil/Kkl*Kk/Kk1;
	
	
